import tkinter as tk
from tkinter import messagebox, Scrollbar, Listbox, Menu
from PIL import Image, ImageTk
import requests
import os
from atproto import Client
import time
import webbrowser
import threading

client = Client(base_url='https://bsky.social')

def get_access_token(identifier: str, password: str):
    try:
        client.login(identifier, password)
        response = requests.post(
            "https://bsky.social/xrpc/com.atproto.server.createSession",
            json={"identifier": identifier, "password": password},
        )
        response.raise_for_status()
        session = response.json()
        return session["accessJwt"]
    except requests.RequestException as e:
        print(f"Erro na requisição: {e}")
        return None
    except Exception as e:
        print(f"Erro inesperado: {e}")
        return None

def on_login():
    user = entry_user.get()
    password = entry_password.get()
    token = get_access_token(user, password)
    
    if token:
        messagebox.showinfo("Sucesso", "Login bem-sucedido!")
        root.destroy()
        success_window()
    else:
        messagebox.showerror("Erro", "Falha ao logar! Verifique suas credenciais.")

def success_window():
    global success_win, text_field, follow_button, clear_button
    
    success_win = tk.Tk()
    success_win.title("O Seguidor")
    success_win.configure(bg="#ffcc00")  # Amarelo
    
    label_text = (
        "Insira os handles dos usuários que deseja seguir. Um handle por linha. "
        "Após preencher a lista, clique em 'Seguir Blueskyers'. Um intervalo de 10 segundos será respeitado entre cada ação."
    )
    tk.Label(success_win, text=label_text, padx=20, pady=20, wraplength=400, bg="#ffcc00", font=("Helvetica", 12)).pack()
        
    text_field = tk.Text(success_win, height=10, width=60, font=("Helvetica", 12), bd=0, bg="#ffffff", padx=10, pady=10)
    text_field.pack(pady=10)
    
    # Carregar conteúdo do arquivo esquerdistas.txt
    if os.path.exists("esquerdistas.txt"):
        with open("esquerdistas.txt", "r") as file:
            text_field.insert(tk.END, file.read())

    follow_button = tk.Button(success_win, text="Seguir Blueskyers", command=process_text, bg="#ff5733", fg="#ffffff", font=("Helvetica", 12), bd=0, relief="raised", padx=10, pady=5)
    follow_button.pack(side=tk.LEFT, padx=10, pady=20)

    clear_button = tk.Button(success_win, text="Limpar", command=clear_text, bg="#ff5733", fg="#ffffff", font=("Helvetica", 12), bd=0, relief="raised", padx=10, pady=5)
    clear_button.pack(side=tk.LEFT, padx=10, pady=20)
    
    success_win.geometry("600x500")
    success_win.mainloop()

def process_text():
    global text_field, follow_button, lines, listbox, line_index

    text_field.pack_forget()
    follow_button.pack_forget()
    clear_button.pack_forget()
    
    list_frame = tk.Frame(success_win, bg="#ffcc00")  # Amarelo
    list_frame.pack(pady=10, fill=tk.BOTH, expand=True)
    
    scrollbar = Scrollbar(list_frame)
    scrollbar.pack(side=tk.RIGHT, fill=tk.Y)
    
    listbox = Listbox(list_frame, yscrollcommand=scrollbar.set, bg="#ffffff", selectmode=tk.SINGLE, font=("Helvetica", 12))
    listbox.pack(side=tk.LEFT, fill=tk.BOTH, expand=True)
    
    scrollbar.config(command=listbox.yview)
    
    content = text_field.get("1.0", tk.END).strip()
    lines = content.split('\n')
    
    for line in lines:
        listbox.insert(tk.END, line)
    
    line_index = 0
    threading.Thread(target=process_next_lines, daemon=True).start()

def process_next_lines():
    global lines, line_index, listbox

    while line_index < len(lines):
        handle = lines[line_index].strip()
        if handle:
            result = follow(handle)
            color = '#d4edda' if result else '#f8d7da'
            success_win.after(0, lambda idx=line_index, bg=color: listbox.itemconfig(idx, {'bg': bg}))
        line_index += 1
        time.sleep(10)  # Tempo de espera entre as ações


def follow(handle):
    handle = handle.lstrip('@')
    url = "https://public.api.bsky.app/xrpc/app.bsky.actor.getProfile"
    headers = {
        'Accept': 'application/json',
    }
    params = {
        'actor': handle
    }
    try:
        response = requests.get(url, headers=headers, params=params)
        response.raise_for_status()
        data = response.json()
        did = data.get('did', 'DID não encontrado')
        uri = client.follow(did).uri
        print(f"Seguindo DID: {did} com URI: {uri}")
        time.sleep(10)
        return did
    except requests.exceptions.RequestException as e:
        print(f"Erro ao fazer a requisição para {handle}: {e}")
        return None

def clear_text():
    text_field.delete("1.0", tk.END)

def show_redskky_info():
    redskky_win = tk.Toplevel(root)
    redskky_win.title("RedSkky")
    redskky_win.geometry("500x400")  # Ajuste o tamanho da janela conforme necessário
    redskky_win.configure(bg="#ffcc00")
    
    # Criar um frame para organizar o layout
    frame = tk.Frame(redskky_win, bg="#ffcc00")
    frame.pack(fill=tk.BOTH, expand=True)
    
    # Criar um widget Text para exibir o texto
    info_text = (
        "Bem-vindo ao Redskky!\n\n"
        "Olá, sou o @lulinucs.duckdns.org e estou explorando o Atproto! Este projeto surgiu após notar que o "
        "@ricardoflor.bsky.social tem uma lista de \"Esquerdistas que seguem de volta\" há algum tempo. Percebi "
        "que alguns usuários estavam interessados em seguir todos esses perfis de uma só vez. Pois bem, é possível!\n\n"
        "Compilei a lista dele, que está disponível em https://lulinucs.duckdns.org/redskky/esquerdistas.txt, "
        "e desenvolvi este software para automatizar o processo. Com o Redskky, você pode carregar a lista automaticamente e, ao clicar no botão "
        "\"Seguir Blueskyers\", o sistema começará a seguir um por um. Para evitar bloqueios por excesso de requisições, o software respeita um intervalo de 10 segundos entre cada ação, "
        "o que é aceitável pela plataforma.\n\n"
        "Você também pode substituir a lista padrão por qualquer outra de sua escolha. O Redskky é essencialmente uma ferramenta para seguir perfis em massa.\n\n"
        "Embora este aplicativo pudesse ser uma aplicação web, meu servidor já está ocupado com outros serviços e eu nunca havia desenvolvido um software com Python e Tkinter. Portanto, "
        "por enquanto, você precisará baixar o arquivo .exe e executá-lo em sua máquina (disponível apenas para Windows por enquanto – mas logo eu, fanboy do Linux, atualizarei isso!).\n\n"
        "Embora seja possível usar sua senha normal para acessar o sistema, é altamente recomendável que você gere uma Senha de Aplicativo no seu Bluesky. Para isso, vá em Configurações > "
        "Avançado > Senhas de Aplicativos e use essa senha para fazer login em aplicativos de terceiros."
    )
    
    text_widget = tk.Text(frame, wrap=tk.WORD, height=20, width=60, font=("Helvetica", 10), bg="#ffffff", padx=10, pady=10)
    text_widget.insert(tk.END, info_text)
    text_widget.config(state=tk.DISABLED)  # Torna o texto não editável
    text_widget.pack(side=tk.LEFT, fill=tk.BOTH, expand=True)
    
    # Adicionar uma barra de rolagem
    scrollbar = tk.Scrollbar(frame, command=text_widget.yview)
    scrollbar.pack(side=tk.RIGHT, fill=tk.Y)
    text_widget.config(yscrollcommand=scrollbar.set)
    
    # Adicionar o botão de fechar
    tk.Button(redskky_win, text="OK", command=redskky_win.destroy, bg="#ff5733", fg="#ffffff", font=("Helvetica", 12)).pack(pady=10)

def open_lulinucs_page():
    webbrowser.open("https://lulinucs.duckdns.org/")

root = tk.Tk()
root.title("Login")
root.configure(bg="#ffcc00")  # Amarelo

# Carregar e redimensionar logo a partir do arquivo local
logo_file = "logo.png"

logo_image = Image.open(logo_file)
logo_image = logo_image.resize((200, 200), Image.ANTIALIAS)  # Redimensionar para 200x200 pixels
logo = ImageTk.PhotoImage(logo_image)

# Adicionar logo à tela principal
tk.Label(root, image=logo, bg="#ffcc00").pack(pady=10)


# Barra de menu
menu_bar = Menu(root)
root.config(menu=menu_bar)

sobre_menu = Menu(menu_bar, tearoff=0)
menu_bar.add_cascade(label="Sobre", menu=sobre_menu)
sobre_menu.add_command(label="RedSkky", command=show_redskky_info)
sobre_menu.add_command(label="lulinucs", command=open_lulinucs_page)

tk.Label(root, text="Usuário:", bg="#ffcc00", font=("Helvetica", 12), fg="#333333").pack(pady=10)
entry_user = tk.Entry(root, font=("Helvetica", 12))
entry_user.pack(pady=5)

tk.Label(root, text="Senha:", bg="#ffcc00", font=("Helvetica", 12), fg="#333333").pack(pady=10)
entry_password = tk.Entry(root, show="*", font=("Helvetica", 12))
entry_password.pack(pady=5)

tk.Button(root, text="Entrar", command=on_login, bg="#ff5733", fg="#ffffff", font=("Helvetica", 12), bd=0, relief="raised", padx=10, pady=5).pack(pady=20)

info_text = (
    "Para segurança adicional, use uma Senha de Aplicativo em vez da senha normal. "
    "No seu Bluesky acesse Configurações > Avançado > Senhas de Aplicativos para gerar uma."
)
info_label = tk.Label(root, text=info_text, bg="#ffcc00", font=("Helvetica", 10), fg="#333333", wraplength=400)
info_label.pack(pady=10)

root.geometry("450x550")
root.mainloop()
